//	ADFS_Menus.h

#ifndef _H_ADFS_Menus
#define	_H_ADFS_Menus

#ifndef __GNUC__
	#include "Menus.h"
#endif

#include "stdio.h"
#include "ADFS_Commands.h"

typedef struct {
	unsigned short	numItems;
	unsigned short	itemA[];
} MBarRec, *MBarPtr, **MBarHandle;

#ifndef ulong
	typedef	unsigned long	ulong;
	typedef	unsigned short	ushort;
#endif

#define	MenuItemCommand(_MENU, _ITEM)	(ulong)((((ulong)(_MENU)) << 16) | ((ulong)(_ITEM)))
#define CommandMenu(_CMD)				(short)(((_CMD) >> 16) & 0xFFFF)
#define	CommandItem(_CMD)				(short)((_CMD) & 0xFFFF)

/**********************/
void	DoAppleMenu(short menuChoice);
void	DoFileMenu(short menuChoice);
void	DoEditMenu(short menuChoice);
void	DoFontMenu(short menuChoice);
void	DoSizeMenu(short menuChoice);

MenuRef		FindMenu(short menuID);
void		UpdateMenus(void);
Boolean		DoMenuKey(EventRecord *theEvent);
void		DoMenu(long command);
Boolean		DoCommand(long command);
void		SetUpMenus(void);

/**********************/
#define		C_MENU_BLANK	" "
#define		P_MENU_BLANK	"\p"C_MENU_BLANK

#define		C_MENU_SEPARATOR	"(-"
#define		P_MENU_SEPARATOR	"\p"C_MENU_SEPARATOR

char	*GetCommandString(ulong command, char *bufZ);
void	AbleMenuItem(MenuRef theMenu, short menuItem, Boolean able);
void	RadioButtonItem(MenuRef theMenu, int firstItem, int lastItem, int buttonItem);
Boolean IsItemEnabled(MenuRef menu, short item);
void	ClearMenu(MenuHandle theMenu);
void	CopyMenu(MenuHandle dest_menu, MenuHandle src_menu);

char	GetCommandMark(ulong command);
void	AbleCommandGroup(ulong firstCmd, ulong lastCmd, Boolean ableB);
void	AbleCommand(ulong cmd, Boolean able);
void	EnableCommand(ulong cmd);
void	DisableCommand(ulong cmd);
void	DashCommand(ulong command, Boolean dash);
void	CheckCommand(ulong command, Boolean check);
void	RadioButtonCommand(ulong firstCmd, ulong lastCmd, ulong buttonCmd);
Boolean	IsCommandEnabled(ulong cmd);
void	CheckMenuGroup(MenuRef theMenu, int firstItem, int lastItem, int checkItem);

#endif